//
// Copyright 2015-2021 by Garmin Ltd. or its subsidiaries.
// Subject to Garmin SDK License Agreement and Wearables
// Application Developer Agreement.
//

import Toybox.Communications;
import Toybox.Cryptography;
import Toybox.Lang;
import Toybox.Timer;

class AtHome
{

var usr;
var pwd;

private var api;

private var cb;
private var state;

public function initialize()
{

    L.dbg_log(L.DBG_BASIC, "AtHome:initialize()");
    usr = C.settings["athome_usr"];
    pwd = C.settings["athome_pwd"];
    api = new TpApi(C.settings["athome_svr"], usr, pwd);
}

public function avail()
{

    return !C.empty(C.settings["athome_svr"]) && !C.empty(C.settings["athome_usr"]);
}

public function enumerate(cb)
{

    L.dbg_log(L.DBG_BASIC, "AtHome:enumerate()");

    if (api.get_host() == null) {
        cb.invoke(C.OUTLET_ATHOME + 1, null); }

    C.set_alert(null, "searching...");

    me.cb = cb;

    var body = {
        "usr" => usr,
        "pwd" => pwd,
        "enumerate" => "wemo"
    };
    api.post("", body, method(:ah_enumerate));
}

private function ah2state(state)
{

    switch (state) {

    case "on":
        return G.STATE_ON;

    case "off":
        return G.STATE_OFF;

    }
    return G.STATE_OFL;
}

public function ah_enumerate(code, data as Dictionary)
{
    var dev, name;

    if (code != 200) {
        C.state = C.MAIN_ERROR;
        var msg = (code == Communications.BLE_CONNECTION_UNAVAILABLE) ? "No phone" :
                                                                        ("Error(" + code + ")");
        cb.invoke(C.OUTLET_ERROR,  "AtHome\n" + msg + "\nTap to continue");
        return;
    }
    var devices = data["devices"] as Dictionary;
    var str = "";
    for (var i = 0; i < devices.size(); i += 1) {
        dev = devices[i] as Dictionary;
        name = dev["name"];
        C.outlets.add({
                        "type" => C.OUTLET_ATHOME,
                        "name" => name,
                        "icon" => G.ICON_PLUG,
                        "state" => ah2state(dev["state"]),
                        "ood" => false,
                        "info" => dev["info"]
                      });
        str += "," + name;
    }
    L.dbg_log(L.DBG_BASIC, "AtHome device" + str);
    cb.invoke(C.OUTLET_ATHOME + 1, null);
}

public function ctrl(cmd, outlet as Dictionary, state, cb)
{

    if (api.get_host() == null) {
        cb.invoke(C.OUTLET_NONE, "no host");
        return;
    }

    me.cb = cb;
    me.state = state;

    switch (cmd) {

    case C.CTRL_ENUMERATE:
        enumerate(cb);
        return;

    case C.CTRL_GET:
        athome_get(outlet);
        return;

    case C.CTRL_SET:
        athome_set(state, outlet);
        return;

    }
    L.dbg_log(L.DBG_BASIC, "ctrl:" + "unknown command" + cmd);
    cb.invoke(cmd, "unknown command");
}

public function athome_get(outlet as Dictionary)
{

    var info = outlet["info"] as Dictionary;

    var body = {
        "usr" => usr,
        "pwd" => pwd,
        "get" => "wemo",
        "addr" => info["addr"]
    };
    api.post("", body, method(:ah_get));
}

public function ah_get(code, data as Dictionary)
{
    var r;

    if (code != 200) {
        cb.invoke(G.STATE_OFL, "Error - " + code);
        return;
    }

    r = G.STATE_OFL;
    switch (data["state"]) {

    case "on":
        r = G.STATE_ON;
        break;

    case "off":
        r = G.STATE_OFF;
        break;

    case "OFL":
        r = G.STATE_OFL;
        break;

    }
    cb.invoke(r, null);
}

public function athome_set(state, outlet as Dictionary)
{

    var info = outlet["info"] as Dictionary;

    var body = {
        "usr" => usr,
        "pwd" => pwd,
        "set" => "wemo",
        "state" => ((state == G.STATE_ON) ? "on" : "off"),
        "addr" => info["addr"]
    };
    api.post("", body, method(:ah_set));
}

public function ah_set(code, data as Dictionary)
{

    cb.invoke(state, ((code == 200) ? null : "set failed"));
}

}
