using Toybox.Application.Properties;
using Toybox.Graphics as Gfx;
using Toybox.Math;
using Toybox.System as Sys;
using Toybox.Time;
using Toybox.Time.Gregorian;

import Toybox.Application.Storage;
import Toybox.Lang;
import Toybox.StringUtil;
import Toybox.WatchUi;

(:glance)
module G
{

//
//  Define my own colors since Garmin is a little color
//  blind (0xff00ff is magenta, not pink).
//
public const BLACK   = 0x000000;
public const WHITE   = 0xffffff;
public const GRAY    = 0x888888;
public const RED     = 0xff0000;
public const GREEN   = 0x00ff00;
public const BLUE    = 0x0000ff;
public const CYAN    = 0x00ffff;
public const MAGENTA = 0xff00ff;
public const YELLOW  = 0xffff00;

//
//  Outlet states
//
public const STATE_OFF      = 0;
public const STATE_ON       = 1;
public const STATE_OFL      = 2;
public const STATE_UNK      = 3;

//
//  Outlet icons
//
public const ICON_PLUG   = 0;
public const ICON_STRIP  = 1;
public const ICON_SWITCH = 2;
public const ICON_BULB   = 3;
public const ICON_SAUNA  = 4;

//
//  icons
//

public const icons_sm = [
    Rez.Drawables.outlet_off_sm, Rez.Drawables.outlet_on_sm, Rez.Drawables.outlet_ofl_sm,
    Rez.Drawables.strip_off_sm,  Rez.Drawables.strip_on_sm,  Rez.Drawables.strip_ofl_sm,
    Rez.Drawables.switch_off_sm, Rez.Drawables.switch_on_sm, Rez.Drawables.switch_ofl_sm,
    Rez.Drawables.bulb_off_sm,   Rez.Drawables.bulb_on_sm,   Rez.Drawables.bulb_ofl_sm,
    Rez.Drawables.sauna_off_sm,  Rez.Drawables.sauna_on_sm,  Rez.Drawables.sauna_ofl_sm,
];

function get_ood(size)
{

    if (size <= 0) {
        return Rez.Drawables.ood_sm; }
    else if (size < 150) {
        return Rez.Drawables.ood_med; }
    return Rez.Drawables.ood_lg;
}

function get_icon(icon, onoff, icons as Array<ResourceId>)
{

    //
    //  This code assumes there are 3 on/off states (0, 1, 2)
    //  and the icons come outlet first, then strip, switch,
    //  bulb, and finally sauna
    //
    switch (icon) {

    case ICON_SAUNA:
        onoff += 3;
        // fall thru
    case ICON_BULB:
        onoff += 3;
        // fall thru
    case ICON_SWITCH:
        onoff += 3;
        // fall thru
    case ICON_STRIP:
        onoff += 3;
        // fall thru
    case ICON_PLUG:
        break;

    }
    return icons[onoff];
}

}
