//
// Copyright 2015-2021 by Garmin Ltd. or its subsidiaries.
// Subject to Garmin SDK License Agreement and Wearables
// Application Developer Agreement.
//

import Toybox.Application;
import Toybox.Graphics;
import Toybox.Lang;
import Toybox.Time;
import Toybox.Timer;
import Toybox.WatchUi;

//! Initial glance view
(:glance)
class GlanceView extends WatchUi.GlanceView
{

var width;
var height;

var dev as Dictionary or Null;

public function initialize()
{

    L.dbg_log(L.DBG_LIFE, "glance:initialize()");
    WatchUi.GlanceView.initialize();
}

function onLayout(dc)
{

    width = dc.getWidth();
    height = dc.getHeight();
    L.dbg_log(L.DBG_LIFE, "glance:onLayout() - " + width + "x" + height);
}

function onShow() as Void
{


    //L.get_settings(true);
    dev = Storage.getValue("Glance_dev");
    if (dev == null) {
        dev = {
                    "name" => "No device",
                    "state" => G.STATE_OFL,
                    "icon" => G.ICON_PLUG,
                    "ood"  => true
              };
    }
    dev["ood"] = true;
    L.pr_mem("glance:onShow()");
}

//! Update the view
//! @param dc Device context
public function onUpdate(dc as Dc)
{

    L.dbg_log(L.DBG_PERIOD, "glance:onUpdate() - " + L.ts2str(Time.now().value(), true));

    dc.setColor(G.BLACK, G.BLACK);
    dc.clear();
    dc.setColor(G.WHITE, G.BLACK);

    var ic_wh = 48;         // change if the icon changes from 48x48
    var h8 = height / 8;

    var f = Graphics.FONT_TINY;
    var fh = dc.getFontHeight(f);
    dc.drawText(0, h8, Graphics.FONT_SMALL, "Outlets/Switches", Graphics.TEXT_JUSTIFY_LEFT);

    if (dev["ood"]) {
        dc.drawBitmap(0, height - h8 - ic_wh, WatchUi.loadResource(G.get_ood(0))); }
    dc.drawBitmap(0, height - h8 - ic_wh, WatchUi.loadResource(G.get_icon(dev["icon"], dev["state"], G.icons_sm)));

    dc.drawText(ic_wh, height - h8 - (fh/2), f, dev["name"], Graphics.TEXT_JUSTIFY_LEFT | Graphics.TEXT_JUSTIFY_VCENTER);
}

//! Called when this View is removed from the screen. Save the
//! state of your app here.
public function onHide() as Void
{

    L.dbg_log(L.DBG_LIFE, "glance:onHide()");
}

public function onReceive(args as Dictionary or String or Null) as Void
{

    L.dbg_log(L.DBG_LIFE, "glance:onReceive()");
    WatchUi.requestUpdate();
}

}
