//
// Copyright 2015-2021 by Garmin Ltd. or its subsidiaries.
// Subject to Garmin SDK License Agreement and Wearables
// Application Developer Agreement.
//

import Toybox.Communications;
import Toybox.Cryptography;
import Toybox.Lang;

class Shelly {

private var state;
private var http;

public function initialize()
{

    L.dbg_log(L.DBG_BASIC, "Shelly:initialize()");
    http = new Http(C.settings["shelly_svr"]);
    http.set_opts({"Content-Type" => Communications.REQUEST_CONTENT_TYPE_JSON},
                  Communications.HTTP_RESPONSE_CONTENT_TYPE_JSON);
}

public function avail()
{

    return !C.empty(C.settings["shelly_svr"]) && !C.empty(C.settings["shelly_key"]);
}

private function sh_uri(url)
{

    return url + "?auth_key=" + C.settings["shelly_key"];
}

private function status2state(onl, output)
{

    if (onl != 1) {
        return G.STATE_OFL; }
    return output ? G.STATE_ON : G.STATE_OFF;
}

private function enumerate(cb)
{

    var body = {"select" => ["status", "settings"], "show" => ["offline", "shared"]};
    http.post(sh_uri("/v2/devices/get"), body, cb, method(:shelly_enumerate_cb));
}

public function shelly_enumerate_cb(code, data as Array<Dictionary>, cb)
{
    var dict;

    for (var i = 0; i < data.size(); ++i) {
        var item = data[i];
        dict = item["settings"] as Dictionary;
        var info = dict["switch:0"] as Dictionary;
        dict = item["status"] as Dictionary;
        var status = dict["switch:0"] as Dictionary;
        L.dbg_log(L.DBG_BASIC, info["name"] + ":" + item["id"]);
        C.outlets.add({
                        "type" => C.OUTLET_SHELLY,
                        "name" => info["name"],
                        "icon" => G.ICON_PLUG,
                        "state" => status2state(item["online"], status["output"]),
                        "ood" => false,
                        "info" => {
                                    "id" => item["id"]
                                  }
                      });
    }

    cb.invoke(C.OUTLET_SHELLY + 1, null);
}

private function shelly_get(dev as Dictionary, cb)
{

    var info = dev["info"] as Dictionary;
    var body = {
                    "ids" => [ info["id"] ],
                    "select" => ["status", "settings"],
                    "show" => ["offline", "shared"]
               };
    http.post(sh_uri("/v2/devices/api/get"), body, cb, method(:shelly_get_cb));
}

public function shelly_get_cb(code, data as Array<Dictionary>, cb)
{

    var item = data[0] as Dictionary;
    var dict = item["status"] as Dictionary;
    var status = dict["switch:0"] as Dictionary;
    cb.invoke(status2state(item["online"], status["output"]), null);
}

private function shelly_set(state, dev as Dictionary, cb)
{

    me.state = state;
    var info = dev["info"] as Dictionary;
    var body = {
                    "id" => info["id"],
                    "on" => ((state == G.STATE_ON) ? true : false)
               };
    http.post(sh_uri("/v2/devices/api/set/switch"), body, cb, method(:shelly_set_cb));
}

public function shelly_set_cb(code, data as Array<Dictionary>, cb)
{

    if (code == 400) {
        cb.invoke(C.OUTLET_ERROR, C.err_msg(code));
        return;
    }
    cb.invoke(state, null);
}

public function ctrl(cmd, outlet as Dictionary, state, cb)
{

    switch (cmd) {

    case C.CTRL_ENUMERATE:
        enumerate(cb);
        return;

    case C.CTRL_GET:
        shelly_get(outlet, cb);
        return;

    case C.CTRL_SET:
        shelly_set(state, outlet, cb);
        return;

    }
    L.dbg_log(L.DBG_BASIC, "ctrl:" + "unknown command" + cmd);
}

}
